from api.api_helper import APIHelper

api_helper = APIHelper(deployed)

ordered_resources = APIHelper.get_ordered_list(deployed.resources)

for resource in ordered_resources:
    print "Configuring Resource {0} on API {1} on {2}".format(resource.name, APIHelper.get_api_name(deployed), deployed.container.name)
    parent_resource_id = APIHelper.get_parent_resource_id(deployed, resource, ordered_resources)
    api_helper.create_resource(parent_resource_id, resource)
    methods = resource.methods
    for method in methods:
        api_helper.create_method(resource, method)
        api_helper.save_url(resource, method)
        api_helper.create_integration(resource, method)
        for response_mapping in method.responseMappings:
            api_helper.create_response_mapping(resource, method, response_mapping)


