
context.addStepWithCheckpoint(steps.jython(
    description="Create %s instance on %s" % (deployed.instanceName if deployed.instanceName else deployed.name, deployed.container.name),
    script="ec2/instance/ec2_create.py",
    order=60
), delta)

if deployed.attachElasticIp:
    context.addStepWithCheckpoint(steps.jython(
        description="Create elastic IP for %s" % (deployed.instanceName if deployed.instanceName else deployed.name),
        script="ec2/elastic_ip/create_elastic_ip.py",
        order=61
    ), delta)

    context.addStepWithCheckpoint(steps.jython(
        description="Associate elastic IP with instance %s" % (deployed.instanceName if deployed.instanceName else deployed.name),
        script="ec2/elastic_ip/associate_elastic_ip.py",
        order=62
    ), delta)

context.addStep(steps.jython(
    description="Wait for %s instance to be in a running state" % (deployed.instanceName if deployed.instanceName else deployed.name),
    script="ec2/instance/ec2_create_running.py",
    order=63
))

if deployed.networkInterfaces:
    for key, value in deployed.networkInterfaces.items():
        context.addStep(steps.jython(
            description="Attach network interface %s to %s instance" % (value, deployed.instanceName if deployed.instanceName else deployed.name),
            script="ec2/ni/attach_network_interface.py",
            order=64,
            jython_context = {"device_index": key, "network_interface": value}
        ))

if deployed.volumes:
    for key, value in deployed.volumes.items():
        context.addStep(steps.jython(
            description="Attach volume %s to %s instance" % (key, deployed.instanceName if deployed.instanceName else deployed.name),
            script="ec2/ebs/ec2_attach_volume.py",
            order=64,
            jython_context = {"volume_id_name": key, "device": value}
        ))

context.addStep(steps.jython(
    description="Wait to ensure the %s instance is fully booted" % (deployed.instanceName if deployed.instanceName else deployed.name),
    script="ec2/instance/ec2_fully_booted.py",
    order=65
))
