from ec2.ec2_helper import EC2Helper


class NIHelper(EC2Helper):
    def __init__(self, deployed):
        super(NIHelper, self).__init__(deployed)

    def get_network_interface_params(self):
        if self.is_starts_with_name(self.deployed.subnet):
            subnetId=self.get_subnet_id_by_name(self.get_property_name(self.deployed.subnet))
        else:
            subnetId=self.deployed.subnet
        params_dict = {'SubnetId': subnetId}
        if self.deployed.networkInterfaceDescription:
            params_dict['Description'] = self.deployed.networkInterfaceDescription
        if self.deployed.securityGroups:
            params_dict['Groups'] = self.get_security_group_id_list(self.deployed.securityGroups)
        if self.deployed.primaryIpAddress:
            params_dict['PrivateIpAddress'] = self.deployed.primaryIpAddress
        if self.deployed.secondaryIpAddress:
            params_dict['PrivateIpAddresses'] = [
                {
                    'PrivateIpAddress': self.deployed.secondaryIpAddress,
                    'Primary': False
                }
            ]
        return params_dict

    def create_network_interface(self):
        params = self.get_network_interface_params()
        create_ni_response = self.ec2_client.create_network_interface(**params)
        if create_ni_response['ResponseMetadata']['HTTPStatusCode'] == 200:
            self.deployed.networkInterfaceId = create_ni_response['NetworkInterface']['NetworkInterfaceId']
            network_interface_name = self.deployed.networkInterfaceName if self.deployed.networkInterfaceName else self.deployed.name
            self.set_network_interface_name(self.deployed.networkInterfaceId, network_interface_name)
        return create_ni_response

    def set_network_interface_name(self, network_interface_id, network_interface_name):
        self.ec2_client.create_tags(DryRun=False, Resources=[network_interface_id],
                                    Tags=[{'Key': 'Name', 'Value': network_interface_name}])

    def delete_network_interface(self):
        delete_response = self.ec2_client.delete_network_interface(
            NetworkInterfaceId=self.deployed.networkInterfaceId
        )

    def modify_network_interface_description(self):
        response = self.ec2_client.modify_network_interface_attribute(
            NetworkInterfaceId=self.deployed.networkInterfaceId,
            Description={
                'Value': self.deployed.networkInterfaceDescription
            })

    def modify_network_interface_scurity_groups(self):
        groups = self.get_security_group_id_list(self.deployed.securityGroups)
        response = self.ec2_client.modify_network_interface_attribute(
            NetworkInterfaceId=self.deployed.networkInterfaceId,
            Groups=groups)

    def modify_network_interface_secondary_ip_address(self):
        response = self.ec2_client.assign_private_ip_addresses(
            NetworkInterfaceId=self.deployed.networkInterfaceId,
            PrivateIpAddresses=[
                self.deployed.secondaryIpAddress
            ],
        )

    def unassign_secondary_ip_address(self, ip_address):
        response = client.unassign_private_ip_addresses(
            NetworkInterfaceId=self.deployed.networkInterfaceId,
            PrivateIpAddresses=[
                ip_address
            ]
        )
