context.addStepWithCheckpoint(steps.jython(
    description="Create VPC %s on %s" % (deployed.vpcName if deployed.vpcName else deployed.name, deployed.container.name),
    script="ec2/vpc/create.py",
    order=50
), delta)
context.addStep(steps.jython(
    description="Wait for VPC %s to be created on %s" % (deployed.vpcName if deployed.vpcName else deployed.name, deployed.container.name),
    script="ec2/vpc/fully_created.py",
    order=51
))
context.addStep(steps.jython(
    description="Setting properties for VPC %s on %s" % (deployed.vpcName if deployed.vpcName else deployed.name, deployed.container.name),
    script="ec2/vpc/set_properties.py",
    order=52
))

# Adding internet gateway steps
if deployed.createInternetGateway:
    vpc_name = deployed.vpcName if deployed.vpcName else deployed.name
    gateway_name = deployed.internetGatewayName if deployed.internetGatewayName else vpc_name + '-gateway'

    context.addStepWithCheckpoint(steps.jython(
        description="Create internet gateway %s in %s" % (gateway_name, deployed.container.name),
        script="ec2/ig/create_internet_gateway.py",
        order=53
    ), delta)
    context.addStep(steps.jython(
        description="Wait for internet gateway %s to be available in %s" % (gateway_name, deployed.container.name),
        script="ec2/ig/wait_internet_gateway_available.py",
        order=54
    ))
    context.addStep(steps.jython(
        description="Apply properties to internet gateway %s in %s" % (gateway_name, deployed.container.name),
        script="ec2/ig/apply_internet_gateway_properties.py",
        order=55
    ))
    context.addStepWithCheckpoint(steps.jython(
        description="Attach internet gateway %s to VPC %s in %s" % (gateway_name, vpc_name, deployed.container.name),
        script="ec2/ig/attach_internet_gateway.py",
        order=56
    ), delta)

