from alb.alb_helper import ALBHelper

alb_helper = ALBHelper(deployed)
load_balancer_name = deployed.loadBalancerName if deployed.loadBalancerName else deployed.name

# Creates application load balancer
context.addStepWithCheckpoint(steps.jython(
    description="Create application ELB {} on {}".format(load_balancer_name, deployed.container.name),
    script="alb/steps/create_alb.py",
    order=63
), delta)

# Configure application elb
# Validate properties
alb_helper.validate_alb()
context.addStep(steps.jython(
    description="Configure application ELB {} on {}".format(load_balancer_name, deployed.container.name),
    script="alb/steps/configure_alb.py",
    order=64
))

# Create listeners
if deployed.listeners:
    # Validate listeners
    alb_helper.validate_listeners()
    context.addStep(steps.jython(
        description="Create listeners for application ELB {} on {}".format(load_balancer_name, deployed.container.name),
        script="alb/steps/create_listeners.py",
        order=64
    ))

# Create listener rules
if deployed.listenerRules:
    # Validate listener rules
    alb_helper.validate_listener_rules()
    context.addStep(steps.jython(
        description="Create listener rules for application ELB {} on {}".format(load_balancer_name, deployed.container.name),
        script="alb/steps/create_listener_rules.py",
        order=65
    ))
