if deployed.vpc != previousDeployed.vpc:
    raise RuntimeError("Subnet's vpc cannot be updated.")

if deployed.cidrBlock != previousDeployed.cidrBlock:
    raise RuntimeError("Subnet's CIDR Block cannot be updated.")

if deployed.ipv6CidrBlock != previousDeployed.ipv6CidrBlock:
    raise RuntimeError("Subnet's IPv6 CIDR Block cannot be updated.")

if deployed.region != previousDeployed.region:
    raise RuntimeError("Subnet's region cannot be updated.")

if deployed.availabilityZone != previousDeployed.availabilityZone:
    raise RuntimeError("Subnet's Availibility Zone cannot be updated.")

description = "Modify subnet %s in %s" % (previousDeployed.subnetName if previousDeployed.subnetName else previousDeployed.name, previousDeployed.container.name)

context.addStepWithCheckpoint(steps.jython(
    description=description,
    script="ec2/vpc/subnet/modify_subnet.py",
    order=55
), delta)
