context.addStepWithCheckpoint(steps.jython(
    description="Create route table %s on VPC %s on %s" % (deployed.routeTableName if deployed.routeTableName else deployed.name, deployed.vpc, deployed.container.name),
    script="ec2/vpc/routes/create_route_table.py",
    order=56
), delta)

if deployed.subnets and len(deployed.subnets) > 0:
    context.addStepWithCheckpoint(steps.jython(
        description="Associate subnets to route table %s on VPC %s on %s" % (deployed.routeTableName if deployed.routeTableName else deployed.name, deployed.vpc, deployed.container.name),
        script="ec2/vpc/routes/associate_subnets.py",
        order=57
    ), delta)

if deployed.is_main:
    context.addStep(steps.jython(
        description="Set route table %s as main table on VPC %s on %s" % (deployed.routeTableName if deployed.routeTableName else deployed.name, deployed.vpc, deployed.container.name),
        script="ec2/vpc/routes/set_as_main_table.py",
        order=58
    ))

if deployed.routes and len(deployed.routes) > 0:
    context.addStep(steps.jython(
        description="Create routes in route table %s on VPC %s on %s" % (deployed.routeTableName if deployed.routeTableName else deployed.name, deployed.vpc, deployed.container.name),
        script="ec2/vpc/routes/create_routes.py",
        order=59
    ))
