
if previousDeployed.is_main:
    context.addStep(steps.jython(
        description="Unset route table %s as main table (and  fallback to original) on VPC %s on %s"
                    % (previousDeployed.routeTableName if previousDeployed.routeTableName else previousDeployed.name, previousDeployed.vpc, previousDeployed.container.name),
        script="ec2/vpc/routes/remove_as_main_table.py",
        order=45
    ))

if previousDeployed.subnets:
    context.addStepWithCheckpoint(steps.jython(
        description="Disassociate all the subnets from route table %s on VPC %s on %s"
                    % (previousDeployed.routeTableName if previousDeployed.routeTableName else previousDeployed.name, previousDeployed.vpc, previousDeployed.container.name),
        script="ec2/vpc/routes/disassociate_subnets.py",
        order=46
    ), delta)


context.addStepWithCheckpoint(steps.jython(
    description="Destroy route table %s from VPC %s on %s" % (previousDeployed.routeTableName if previousDeployed.routeTableName else previousDeployed.name, previousDeployed.vpc, previousDeployed.container.name),
    script="ec2/vpc/routes/destroy_route_table.py",
    order=47
), delta)
