from cloudformation.utils.cf_client import CFClient


def process(task_vars):
    deployed = task_vars['deployed']

    client = CFClient.new_instance(deployed.container)
    try:
        if client.wait_for_ready_status(deployed):
            print "Stack '%s' complete." % deployed.name
        else:
            print "Stack '%s' failed to complete." % deployed.name
    finally:
        client.print_resources(deployed)
    print "Done"


if __name__ == '__main__' or __name__ == '__builtin__':
    process(locals())
