# Raise exception if amiId, region, security groups, keyName, instanceBootRetryCount, subnet
from ec2.instance.ec2_instance_helper import EC2InstanceHelper
instace_helper_deployed = EC2InstanceHelper(deployed)
instance_helper_previous_deployed = EC2InstanceHelper(previousDeployed)

if previousDeployed.amiId != deployed.amiId:
    raise RuntimeError("AMI id of an ec2 instance can not be modified.")
if previousDeployed.region != deployed.region:
    raise RuntimeError("Region of an ec2 instance can not be modified.")
if previousDeployed.securityGroup != deployed.securityGroup:
    raise RuntimeError("Security Groups of an ec2 instance can not be modified.")
if previousDeployed.keyName != deployed.keyName:
    raise RuntimeError("Key Name of an ec2 instance can not be modified.")
if previousDeployed.instanceBootRetryCount != deployed.instanceBootRetryCount:
    raise RuntimeError("Instance Boot Retry Count of an ec2 instance can not be modified.")
if previousDeployed.subnet != deployed.subnet:
    raise RuntimeError("Subnet of an ec2 instance can not be modified.")
if previousDeployed.availabilityZone != deployed.availabilityZone:
    raise RuntimeError("Availability zone of an ec2 instance can not be modified.")
if previousDeployed.elasticIpDomain != deployed.elasticIpDomain:
    raise RuntimeError("Elastic IP domain of an ec2 instance can not be modified.")
if len(set(previousDeployed.volumes) - set(deployed.volumes)) > 0:
    raise RuntimeError("Volumes can not be updated on an existing EC2 instance. It's recommended to undeploy and deploy the provisioning package again.")
if (instance_helper_previous_deployed.is_ni_with_0_index() and not instace_helper_deployed.is_ni_with_0_index()) or \
    (instance_helper_previous_deployed.is_ni_with_0_index() and instace_helper_deployed.is_ni_with_0_index() and
        previousDeployed.networkInterfaces[EC2InstanceHelper.ni_device_index_0] != deployed.networkInterfaces[EC2InstanceHelper.ni_device_index_0]):
    raise RuntimeError("Network interface at device index 0 cannot be modified or detached.")


def add_modify_step():
    context.addStep(steps.jython(
        description="Modify properties of instance %s on %s" % (deployed.instanceName if deployed.instanceName else deployed.name, deployed.container.name),
        script="ec2/instance/ec2_modify.py",
        order=82
    ))

def add_create_elastic_ip_step():
    context.addStepWithCheckpoint(steps.jython(
        description="Create elastic IP for instance %s" % (deployed.instanceName if deployed.instanceName else deployed.name),
        script="ec2/elastic_ip/create_elastic_ip.py",
        order=82
    ), delta)

def add_release_elastic_ip_step():
    context.addStepWithCheckpoint(steps.jython(
        description="Disassociate elastic IP %s" % (previousDeployed.publicIp),
        script="ec2/elastic_ip/disassociate_elastic_ip.py",
        order=15
    ), delta)

    context.addStepWithCheckpoint(steps.jython(
        description="Destroy elastic IP %s" % (previousDeployed.publicIp),
        script="ec2/elastic_ip/release_elastic_ip.py",
        order=16
    ), delta)

def add_associate_elastic_ip_step():
    if deployed.elasticIpDomain == 'standard':
        elastic_associate_order = 83
    else:
        elastic_associate_order = 85
    context.addStepWithCheckpoint(steps.jython(
        description="Associate elastic IP with instance %s" % (deployed.instanceName if deployed.instanceName else deployed.name),
        script="ec2/elastic_ip/associate_elastic_ip.py",
        order=elastic_associate_order
    ), delta)

restart = False

def add_stop_start_steps():
    context.addStep(steps.jython(
        description="Stop instance %s on %s" % (previousDeployed.instanceName if previousDeployed.instanceName else previousDeployed.name, previousDeployed.container.name),
        script="ec2/instance/ec2_stop.py",
        order=80
    ))
    context.addStep(steps.jython(
        description="Wait for instance %s to be stopped" % (previousDeployed.instanceName if previousDeployed.instanceName else previousDeployed.name),
        script="ec2/instance/ec2_instance_stopped.py",
        order=81
    ))
    context.addStep(steps.jython(
        description="Start instance %s on %s" % (deployed.instanceName if deployed.instanceName else deployed.name, deployed.container.name),
        script="ec2/instance/ec2_start.py",
        order=83
    ))
    context.addStep(steps.jython(
        description="Wait for instance %s to be running" % (deployed.instanceName if deployed.instanceName else deployed.name),
        script="ec2/instance/ec2_create_running.py",
        order=84
    ))
    context.addStep(steps.jython(
        description="Wait for instance %s to be fully booted" % (deployed.instanceName if deployed.instanceName else deployed.name),
        script="ec2/instance/ec2_fully_booted.py",
        order=85
    ))

# Adding restart step if modified properties needs restart
if previousDeployed.instanceType != deployed.instanceType or \
        previousDeployed.tenancy != deployed.tenancy or \
        previousDeployed.userData != deployed.userData:
    add_stop_start_steps()
    add_modify_step()
    restart = True
elif previousDeployed.iAmRoleARN != deployed.iAmRoleARN or \
        previousDeployed.shutdownBehavior != deployed.shutdownBehavior or \
        previousDeployed.detailedMonitoring != deployed.detailedMonitoring or \
        previousDeployed.terminationProtection != deployed.terminationProtection or \
        previousDeployed.instanceTags != deployed.instanceTags or \
        previousDeployed.instanceName != deployed.instanceName:
    add_modify_step()

if (previousDeployed.attachElasticIp and not deployed.attachElasticIp) and not restart:
    add_stop_start_steps()
    restart = True

if not deployed.networkInterfaces == previousDeployed.networkInterfaces:
    for key in set(previousDeployed.networkInterfaces.keys()):
        if key != EC2InstanceHelper.ni_device_index_0:
            context.addStep(steps.jython(
                description="Detach network interface %s from instance %s" % (previousDeployed.networkInterfaces.get(key), previousDeployed.instanceName if previousDeployed.instanceName else previousDeployed.name),
                script="ec2/ni/detach_network_interface.py",
                order=15,
                jython_context = {"network_interface": previousDeployed.networkInterfaces.get(key)}
            ))
            context.addStep(steps.jython(
                description="Wait for network interface %s to be detached from instance %s" % (previousDeployed.networkInterfaces.get(key), previousDeployed.instanceName if previousDeployed.instanceName else previousDeployed.name),
                script="ec2/ni/wait_detach_network_interface.py",
                order=16,
                jython_context = {"network_interface": previousDeployed.networkInterfaces.get(key)}
            ))
    for key in deployed.networkInterfaces.keys():
        if key != EC2InstanceHelper.ni_device_index_0:
            context.addStep(steps.jython(
                description="Attach network interface %s to instance %s" % (deployed.networkInterfaces.get(key), deployed.instanceName if deployed.instanceName else deployed.name),
                script="ec2/ni/attach_network_interface.py",
                order=84,
                jython_context = {"device_index": key, "network_interface": deployed.networkInterfaces.get(key)}
            ))


for key in set(deployed.volumes) - set(previousDeployed.volumes):
    context.addStep(steps.jython(
        description="Attach volume %s to instance %s" % (key, previousDeployed.instanceName if previousDeployed.instanceName else previousDeployed.name),
        script="ec2/ebs/ec2_attach_volume.py",
        order=84,
        jython_context={"volume_id_name": key, "device": deployed.volumes.get(key)}
    ))

if previousDeployed.attachElasticIp and deployed.attachElasticIp and restart and deployed.elasticIpDomain == 'standard':
    add_associate_elastic_ip_step()
elif not previousDeployed.attachElasticIp and deployed.attachElasticIp:
    add_create_elastic_ip_step()
    add_associate_elastic_ip_step()
elif previousDeployed.attachElasticIp and not deployed.attachElasticIp:
    add_release_elastic_ip_step()
