from cloudformation.utils.cf_client import CFClient
from com.xebialabs.deployit.provision import ProvisionHelper

client = CFClient.new_instance(deployed.container)

resources = client.list_resources(deployed)

generated_cis = []
generated_ids = []
for resource in resources:
    ci = client.create_ci(resource, deployed.container.account)
    if ci is not None:
        if repositoryService.exists(ci.id):
            repositoryService.update(ci.id, ci)
            print("'%s' of type '%s' updated from '%s' resource." % (ci.id, ci.type, resource['ResourceType']))
        else:
            repositoryService.create(ci.id, ci)
            print("'%s' of type '%s' created from '%s' resource." % (ci.id, ci.type, resource['ResourceType']))
        generated_cis.append(ci)
        generated_ids.append(ci.id)

cis_to_delete = []
if (previousDeployed):
    for ci in previousDeployed.generatedConfigurationItems:
        if ci.type != "udm.Environment" and ci.type != "udm.Dictionary":
            if ci.id not in generated_ids:
                cis_to_delete.append(ci.id)

# Update environment members
environment_id = ProvisionHelper.getProvisionEnvironmentId(deployed.environmentPath, deployedApplication.environment.id)
environment = ProvisionHelper.getOrCreateEnvironment(environment_id, context)
members = environment.members
for ci in generated_cis:
    members.add(ci)
members_to_remove = []
for ci in members:
    if ci.id in cis_to_delete:
        print("'%s' removed from 'members' property '%s'" % (ci.id, environment_id))
        members_to_remove.append(ci)
for ci in members_to_remove:
    members.remove(ci)
environment.setMembers(members)
repositoryService.update(environment_id, environment)

# Update generatedConfigurationItems
generatedConfigurationItems = deployed.generatedConfigurationItems
for ci in generated_cis:
    generatedConfigurationItems.add(ci)
if environment_id != deployedApplication.environment.id:
    generatedConfigurationItems.add(environment)

generated_to_remove = []
for ci in generatedConfigurationItems:
    if ci.id in cis_to_delete:
        print("'%s' removed from 'generatedConfigurationItems' property of '%s'" % (ci.id, deployed.id))
        generated_to_remove.append(ci)
for ci in generated_to_remove:
    generatedConfigurationItems.remove(ci)
deployed.setGeneratedConfigurationItems(generatedConfigurationItems)
if repositoryService.exists(deployed.id):
    repositoryService.update(deployed.id, deployed)

for ci_id in cis_to_delete:
    repositoryService.delete(ci_id)
    print("'%s' deleted" % ci_id)
