from cloudformation.utils.resource_mapper import ResourceMapper


class EKSMapper(ResourceMapper):
    def __init__(self, session, region, verify_ssl):
        super(EKSMapper, self).__init__("k8s.Master")
        self.eks_client = session.client('eks', region_name=region, verify=verify_ssl)
        # k8s.Master property => EKS Cluster property
        self.propertyMapper = {'clusterName':  'name',
                               'apiServerURL': 'endpoint'}

    def create_ci(self, cf_resource, cloud):
        if self.type_supported(cf_resource['PhysicalResourceId']):
            print("Creating CI of type 'k8s.Master' from '%s'" % cf_resource['PhysicalResourceId'])
            eks_cluster = self.eks_client.describe_cluster(name=cf_resource['PhysicalResourceId'])['cluster']
            cloud_id = cloud.id
            id = cloud_id[:cloud_id.rfind('/')+1] + cf_resource['PhysicalResourceId'] + "-EKSCluster"
            properties = {'isEKS':        True,
                          'accessKey':    cloud.getProperty('accesskey'),
                          'accessSecret': cloud.getProperty('accessSecret'),
                          'skipTLS':      True}
            for property in self.propertyMapper:
                properties[property] = eks_cluster[self.propertyMapper[property]]
            return super(EKSMapper, self)._create_ci(id, properties)
        else:
            return None
