/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.aws.upgrade;

import com.xebialabs.deployit.server.api.repository.RawRepository;
import com.xebialabs.deployit.server.api.upgrade.JcrUpgrade;
import com.xebialabs.deployit.server.api.upgrade.UpgradeException;
import com.xebialabs.deployit.server.api.upgrade.Version;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CITypeUpgrader
extends JcrUpgrade {
    private static final Logger logger = LoggerFactory.getLogger(CITypeUpgrader.class);

    public boolean doUpgrade(RawRepository repository) throws UpgradeException {
        logger.info("*** Starting AWS CI type upgrade ***");
        Map<String, String> renamedCis = this.getRenamedCis();
        renamedCis.entrySet().stream().forEach(entry -> repository.renameType((String)entry.getKey(), (String)entry.getValue()));
        logger.info("*** AWS CI type upgrade done ***");
        return true;
    }

    private Map<String, String> getRenamedCis() {
        HashMap<String, String> cis = new HashMap<String, String>();
        cis.put("aws.ec2.VPC", "aws.vpc.VPC");
        cis.put("aws.ec2.VPCSpec", "aws.vpc.VPCSpec");
        cis.put("aws.ec2.Subnet", "aws.vpc.Subnet");
        cis.put("aws.ec2.SubnetSpec", "aws.vpc.SubnetSpec");
        cis.put("aws.ec2.SecurityGroup", "aws.vpc.SecurityGroup");
        cis.put("aws.ec2.SecurityGroupSpec", "aws.vpc.SecurityGroupSpec");
        cis.put("aws.ec2.SecurityGroupInboundRule", "aws.vpc.SecurityGroupInboundRule");
        cis.put("aws.ec2.SecurityGroupInboundRuleSpec", "aws.vpc.SecurityGroupInboundRuleSpec");
        cis.put("aws.ec2.SecurityGroupOutboundRule", "aws.vpc.SecurityGroupOutboundRule");
        cis.put("aws.ec2.SecurityGroupOutboundRuleSpec", "aws.vpc.SecurityGroupOutboundRuleSpec");
        cis.put("aws.ec2.EbsVolume", "aws.ec2.EBSVolume");
        cis.put("aws.ec2.EbsVolumeSpec", "aws.ec2.EBSVolumeSpec");
        cis.put("aws.LambdaFunction.Zip", "aws.lambda.Function");
        cis.put("aws.LambdaFunction.ZipSpec", "aws.lambda.FunctionZip");
        return cis;
    }

    public Version upgradeVersion() {
        return Version.valueOf((String)"xld-aws-plugin", (String)"7.5.0");
    }
}

