from cloudformation.utils.cf_client import CFClient


def process(task_vars):
    deployed = task_vars['deployed']

    client = CFClient.new_instance(deployed.container)
    response = client.validate_template(deployed)
    if response:
        print("Stack '%s' validated successfully." % deployed.name)
    else:
        raise Exception("Stack '%s' validation failed." % deployed.name)


if __name__ == '__main__' or __name__ == '__builtin__':
    process(locals())
