from commons.aws_helper import AWSHelper
import mimetypes

class S3Helper(AWSHelper):
    def __init__(self, deployed):
        super(S3Helper, self).__init__(deployed.container)
        self.s3_client = self.get_aws_client(resource_name='s3', region=deployed.container.region)
        self.deployed = deployed


    def upload_file_on_bucket(self, key, acl, file):
        mime_type = mimetypes.guess_type(file.name)[0]
        return self.upload_file(acl, file, key, mime_type)

    def upload_file(self, acl, file, key, mime_type=None):
        upload_params = {'ACL': acl,
                         'Bucket': self.deployed.container.bucketName,
                         'Key': key,
                         'Body': file}
        if mime_type:
            upload_params.update({'ContentType': mime_type})
        return self.s3_client.put_object(**upload_params)

    def delete_file_from_bucket(self, key):
        hosting_response = self.s3_client.delete_object(
            Bucket=self.deployed.container.bucketName, Key=key)
        return hosting_response
