# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class ContainerGroup(Resource):
    """A container group.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param location: Resource location
    :type location: str
    :param tags: Resource tags
    :type tags: dict
    :ivar provisioning_state: The provisioning state, which only appears in
     the response.
    :vartype provisioning_state: str
    :param containers: The containers in this container group.
    :type containers: list of :class:`Container
     <azure.mgmt.containerinstance.models.Container>`
    :param image_registry_credentials: The image registry credentials by which
     the container group is created from.
    :type image_registry_credentials: list of :class:`ImageRegistryCredential
     <azure.mgmt.containerinstance.models.ImageRegistryCredential>`
    :param restart_policy: - `always` Always restart
     . Possible values include: 'always'
    :type restart_policy: str or :class:`ContainerRestartPolicy
     <azure.mgmt.containerinstance.models.ContainerRestartPolicy>`
    :param ip_address: The IP address type.
    :type ip_address: :class:`IpAddress
     <azure.mgmt.containerinstance.models.IpAddress>`
    :param os_type: The base level OS type required by the containers in the
     group. Possible values include: 'Windows', 'Linux'
    :type os_type: str or :class:`OperatingSystemTypes
     <azure.mgmt.containerinstance.models.OperatingSystemTypes>`
    :ivar state: The state of the container group. Only valid in response.
    :vartype state: str
    :param volumes: The volumes for this container group.
    :type volumes: list of :class:`Volume
     <azure.mgmt.containerinstance.models.Volume>`
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
        'state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'containers': {'key': 'properties.containers', 'type': '[Container]'},
        'image_registry_credentials': {'key': 'properties.imageRegistryCredentials', 'type': '[ImageRegistryCredential]'},
        'restart_policy': {'key': 'properties.restartPolicy', 'type': 'str'},
        'ip_address': {'key': 'properties.ipAddress', 'type': 'IpAddress'},
        'os_type': {'key': 'properties.osType', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'volumes': {'key': 'properties.volumes', 'type': '[Volume]'},
    }

    def __init__(self, location, tags=None, containers=None, image_registry_credentials=None, restart_policy=None, ip_address=None, os_type=None, volumes=None):
        super(ContainerGroup, self).__init__(location=location, tags=tags)
        self.provisioning_state = None
        self.containers = containers
        self.image_registry_credentials = image_registry_credentials
        self.restart_policy = restart_policy
        self.ip_address = ip_address
        self.os_type = os_type
        self.state = None
        self.volumes = volumes
