import xml.etree.ElementTree as ET
import requests

from xld.azure.connector import AzureConnector

rg = deployed.container
cloud = rg.container
connector = AzureConnector(cloud)
web_client = connector.web_client()

function_app_name = deployed.appName or deployed.name
resource_group_name = rg.resourceGroupName or rg.name

# synchronous
credentials = web_client.web_apps.list_publishing_profile_xml_with_secrets(
    resource_group_name=resource_group_name,
    name=function_app_name,
    format='Ftp'
)

if deployed.osType == 'Linux':
    print "Uploaded artifact as part of functionapp creation"
else:
    #Parse credentials from XML
    print "Uploading Function App artifact {0} under Resource Group {1}".format(function_app_name, resource_group_name)
    root = ET.XML(''.join(credentials))
    for publishProfile in root:
        if publishProfile.attrib['publishMethod'] == 'MSDeploy':
            api_username = publishProfile.attrib['userName']
            api_password = publishProfile.attrib['userPWD']

    upload_url="https://" + function_app_name + ".scm.azurewebsites.net/api/zip/site/wwwroot"
    files = open(deployed.file.path, 'rb')

    r = requests.put(url=upload_url, data=files, auth=(api_username, api_password))

    logger.info("Result: {0}".format(r))

functions_list = "https://management.azure.com/subscriptions/" + connector.subscription_id + "/resourceGroups/" + resource_group_name + "/providers/Microsoft.Web/sites/" + function_app_name + "/functions?api-version=2022-03-01"
token = connector.credentials.token['access_token']
headers = {"Authorization":"Bearer " + token}
r = requests.get(url=functions_list, headers=headers)

logger.info("Result: {0}".format(r.json()))

deployed.function_app_url = "https://" + function_app_name + ".azurewebsites.net/api/"

functions = r.json()

if 'value' in functions:
    for function in functions['value']:
        function_name = function['properties']['name']
        function_url = deployed.function_app_url + function_name
        print "Uploaded function '" + function_name + "' -> " + function_url
deployed.function_app_url = "https://" + function_app_name + ".azurewebsites.net/api/"
