import requests
from xld.azure.connector import AzureConnector

cloud = deployed.container
connector = AzureConnector(cloud)
subscription_id = deployed.container.subscriptionId
resource_group_name = deployed.resourceGroupName or deployed.name

logger.info("Checking existence of {0} under SubscriptionId {1}".format(resource_group_name, subscription_id))

retry_count = 0
sleep_interval = 5
while True:
    retry_count += 1
    if retry_count > deployed.maxRetries:
        raise Exception("Timed out waiting for ResourceGroup creation %s" % resource_group_name)

    logger.info("Checking existence of {0} under SubscriptionId {1}".format(resource_group_name, subscription_id))

    url = "https://management.azure.com/subscriptions/{}/resourcegroups/{}?api-version=2021-04-01".format(deployed.container.subscriptionId,resource_group_name)
    headers = {'Content-Type': 'application/json','Authorization': 'Bearer ' + connector.credentials.token['access_token']}
    response = requests.head(url, headers=headers, proxies=connector.proxiesdict)

    is_group_present = True
    if(response.status_code == 204):
        is_group_present = True
        print "Resource Group {0} created.".format(resource_group_name)
        break
    if(response.status_code == 404):
        is_group_present = False
        print "Resource Group {0} not created yet.".format(resource_group_name)
        time.sleep(sleep_interval)
