import requests
import json

from xld.azure.connector import AzureConnector

cloud = deployed.container
connector = AzureConnector(cloud)

org_url = deployed.organizationUrl

if org_url.endswith('/'):
    org_url = my_str = org_url[:-1]

org_name = org_url.rsplit('/', 1)[-1]
project_name = deployed.projectName
req_body = json.dumps({'name': deployed.feedName})

scope = deployed.scope
if scope == 'project' and project_name is None:
    raise Exception('Porject name is mandatory when scope is project')
    return

if scope == 'project':
    create_feed = "https://feeds.dev.azure.com/{}/{}/_apis/packaging/feeds?api-version=6.0-preview.1"
    create_feed = create_feed.format(org_name, project_name)
else:
    create_feed = "https://feeds.dev.azure.com/{}/_apis/packaging/feeds?api-version=6.0-preview.1"
    create_feed = create_feed.format(org_name)
    
token = "Bearer " + connector.credentials.token['access_token']

client = connector.resource_client()

headers = {
    "Content-type": "application/json",
    "Authorization": token
}

r = connector.get_requests_session().post(url=create_feed, headers=headers, data = req_body, verify=cloud.verifySSL)

print("status_code {0}".format(r.status_code))
print("text {0}".format(r.text))

response_data = json.loads(r.text)

if r.status_code != 201 and response_data["typeKey"] == 'FeedNameAlreadyExistsException':
    raise Exception("Feed with name already exists")
elif r.status_code != 201 and response_data["typeKey"] == 'InvalidFeedNameException':
    raise Exception('Invalid feed name. Feed names can not contain spaces, start with a "." or "_", end with a ".", and can not contain any other special characters') 
elif r.status_code != 201 and response_data["typeKey"] == 'FeedNotReleasedException':
    raise Exception('Feed name not available. A feed with name exists in recycle bin') 
elif r.status_code != 201:
    raise Exception('Feed creation failed. Check if user has access and check if the Organization Url and Project Name are correct') 
    
