from azure.mgmt.web.models import AppServicePlan, SkuDescription, Site, SiteConfig, NameValuePair
from xld.azure import get_operation_name

from xld.azure.connector import AzureConnector
from xld.azure import string_or_none
from xld.azure.blob_container.blob_file_helper import BlobFileHelper

import time

def create_blob_container_and_upload(az_cloud, account_key):
    container_name = "function-releases"

    blob_file_helper = BlobFileHelper(deployed, cloud)

    block_blob_service = blob_file_helper.get_block_blobservice(deployed.storageAccount, account_key)

    print "Block Blob Service created"

    block_blob_service.create_container(
        container_name=container_name,
        metadata=None,
        public_access="Container"
    )

    print "Blob Container '{0}' to upload zip created".format(container_name)

    timestr = time.strftime("%Y%m%d-%H%M%S")
    file_name = deployed.name + timestr
    print "Uploading %s on %s." % (file_name, container_name)

    blob_file_helper.upload_blob_using_account_name_key(deployed.storageAccount, account_key, container_name, file_name, deployed.file.path)
    print "Upload %s on %s complete." % (file_name, container_name)
    uploaded_blob_url =  "https://%s.blob.core.windows.net/function-releases/%s" % (deployed.storageAccount, file_name)
    return uploaded_blob_url

rg = deployed.container
app_settings = deployed.appSettings
cloud = rg.container
connector = AzureConnector(cloud)
web_client = connector.web_client()
storage_client = connector.storage_client()

function_app_name = deployed.appName or deployed.name
resource_group_name = rg.resourceGroupName or rg.name
os_type = deployed.osType

print "{0} App Service Plan {1} under Resource Group {2}".format(
    get_operation_name(previousDeployed),
    deployed.servicePlanName,
    resource_group_name)

reserved=False
sku=SkuDescription(
    name="Y1",
    tier="Dynamic",
    size="1",
    family="Y",
    capacity=0
)

if os_type == 'Linux':
    app_service_plan=AppServicePlan(app_service_plan_name=deployed.servicePlanName,location=deployed.location,sku=sku,reserved=True)
else:
    app_service_plan=AppServicePlan(app_service_plan_name=deployed.servicePlanName,location=deployed.location,sku=sku)

op_result = web_client.app_service_plans.create_or_update(
    resource_group_name=resource_group_name,
    name=deployed.servicePlanName,
    app_service_plan=app_service_plan,
    raw=True
)

logger.info("Result: {0}".format(op_result))

print "{0} Function App {1} under Resource Group {2}".format(
    get_operation_name(previousDeployed),
    function_app_name,
    resource_group_name)

storage_keys = storage_client.storage_accounts.list_keys(resource_group_name, deployed.storageAccount)
storage_keys = {v.key_name: v.value for v in storage_keys.keys}
connection_string = "DefaultEndpointsProtocol=https;AccountName=" + deployed.storageAccount + ";AccountKey=" + storage_keys['key1']

function_app_settings = [NameValuePair(name='AzureWebJobsStorage', value=connection_string)]

for key in app_settings:
    function_app_settings.append(NameValuePair(name=key, value=app_settings[key]))

server_farm_id = "/subscriptions/" + connector.subscription_id + "/resourceGroups/" + resource_group_name + "/providers/Microsoft.Web/serverfarms/" + deployed.servicePlanName

# asynchronous
site_config=SiteConfig(
    app_settings=function_app_settings
)

kind ="functionapp"
if os_type == 'Linux':
    kind ="functionapp,linux"

    linux_fx_version = deployed.linuxFxVersion
    if not linux_fx_version:
        raise Exception('Linux Fx Version mandatory for Linux Service plans')
    site_config.linux_fx_version = linux_fx_version

    if deployed.workerRuntime:
        function_app_settings.append(NameValuePair(name='FUNCTIONS_WORKER_RUNTIME', value=deployed.workerRuntime))
    if deployed.extensionVersion:
         function_app_settings.append(NameValuePair(name='FUNCTIONS_EXTENSION_VERSION', value=deployed.extensionVersion))

    uploaded_blob_url = create_blob_container_and_upload(cloud, storage_keys['key1'])
    function_app_settings.append(NameValuePair(name='WEBSITE_RUN_FROM_PACKAGE', value=uploaded_blob_url))

op_result = web_client.web_apps.create_or_update(
    resource_group_name=resource_group_name,
    name=function_app_name,
    site_envelope=Site(
        location=deployed.location,
        kind=kind,
        server_farm_id=server_farm_id,
        site_config=site_config,
        https_only= True if deployed.isHttpsOnly else False
    ),
    raw=True
)

deployed.function_app_url = "https://" + function_app_name + ".azurewebsites.net/api/"
