from xld.azure import wait_for_success_provisioning

from msrestazure.azure_exceptions import CloudError
from xld.azure.connector import AzureConnector

rg = previousDeployed.container
cloud = rg.container
connector = AzureConnector(cloud)
compute_client = connector.compute_client()


resource_group_name = rg.resourceGroupName or rg.name
virtual_machine_name = previousDeployed.virtualMachineName or previousDeployed.name


try:
    # synchronous
    op_result = compute_client.virtual_machines.get(
        resource_group_name=resource_group_name,
        vm_name=virtual_machine_name,
        expand='instanceview'
    )

    if (op_result.instance_view and
            op_result.instance_view.statuses and
            op_result.instance_view.statuses[0].code.startswith('ProvisioningState/failed')):
        print "VM is already in faulty state, nothing to deallocate ({0})".format(
            op_result.instance_view.statuses[0].code)

    else:
        result = wait_for_success_provisioning(op_result, virtual_machine_name)
        if (result == "SUCCESS" and op_result.instance_view.statuses and
                op_result.instance_view.statuses[1].code != 'PowerState/deallocated'):
            print "Waiting for {0} to be deallocated ({1})".format(
                virtual_machine_name, op_result.provisioning_state)
            result = "RETRY"

    logger.info("Result: {0}".format(op_result))

except CloudError as e:
    print e.error.error  # if instance is not present it is also considered deallocated
    if not (e.error.error in ['ResourceNotFound', 'NotFound']):
        raise
