from xld.azure import wait_for_success_provisioning

from xld.azure.connector import AzureConnector

rg = deployed.container
cloud = rg.container
connector = AzureConnector(cloud)
storage_client = connector.storage_client()

# synchronous
op_result = storage_client.storage_accounts.get_properties(
    resource_group_name=rg.resourceGroupName,
    account_name=deployed.storageAccountName
)

result = wait_for_success_provisioning(op_result, deployed.storageAccountName)

logger.info("Result: {0}".format(op_result))

if result == "SUCCESS":
    storage_keys = storage_client.storage_accounts.list_keys(rg.resourceGroupName, deployed.storageAccountName)
    storage_keys = {v.key_name: v.value for v in storage_keys.keys}

    deployed.key1 = storage_keys['key1']
    deployed.key2 = storage_keys['key2']
