from azure.mgmt.storage.models import ProvisioningState
from enum import Enum


def check_persistent_parameters(ci, prev_ci, parameters):
    if prev_ci:
        for attr in parameters:
            if prev_ci[attr] != ci[attr]:
                raise Exception(
                    'Attribute {0} is not allowed to change on update ({1} -> {2})!'
                    .format(attr, prev_ci[attr], ci[attr]))

    return True


def get_enum_by_value(value, enumclass):
    for x in enumclass:
        if x.value == value:
            return x
    return None


def get_operation_name(prev_ci):
    return "Modifying" if prev_ci else "Creating"


def wait_for_success_provisioning(r, what):
    state = r.provisioning_state
    if not isinstance(state, Enum) and state == 'Failed':
        raise Exception("Action for {0} was executed, but parameters caused critical failure".format(what))
    elif (isinstance(state, Enum) and state != ProvisioningState.succeeded) or \
         (not isinstance(state, Enum) and state != 'Succeeded'):
        print "Waiting for {0} to be completely created ({1})".format(what, r.provisioning_state)
        return "RETRY"
    return "SUCCESS"


def string_or_none(s):
    if not s:
        return None
    return str(s)


def int_or_none(s):
    if not s:
        return None
    return int(s)


def object_or_none(obj):
    if not obj:
        return None
    return obj


def boolean_or_none(s):
    if not s:
        return None
    if s in ['true', '1', 'True']:
        return True
    if s in ['false', '0', 'False']:
        return False
    raise Exception("{0} can not be parsed as boolean".format(s))
