from azure.mgmt.network.models import NetworkSecurityGroup, SecurityRule
from xld.azure import get_operation_name

from xld.azure.connector import AzureConnector

rg = deployed.container
cloud = rg.container
connector = AzureConnector(cloud)

network_client = connector.network_client()

group_security_rules = []
group_default_security_rules = []

for rule in deployed.securityRules:
    group_security_rules.append(
        SecurityRule(
            name=rule.securityRuleName,
            access=rule.access,
            description=rule.description,
            destination_address_prefix=rule.destinationAddressPrefix,
            destination_port_range=rule.destinationPortRange,
            direction=rule.direction,
            priority=rule.priority,
            protocol=rule.protocol,
            source_address_prefix=rule.sourceAddressPrefix,
            source_port_range=rule.sourcePortRange
        )
    )

for rule in deployed.defaultSecurityRules:
    group_default_security_rules.append(
        SecurityRule(
            name=rule.securityRuleName,
            access=rule.access,
            description=rule.description,
            destination_address_prefix=rule.destinationAddressPrefix,
            destination_port_range=rule.destinationPortRange,
            direction=rule.direction,
            priority=rule.priority,
            protocol=rule.protocol,
            source_address_prefix=rule.sourceAddressPrefix,
            source_port_range=rule.sourcePortRange
        )
    )

security_group_params_create = NetworkSecurityGroup(
    location=deployed.location,
    security_rules=group_security_rules,
    default_security_rules=group_default_security_rules,
    tags=deployed.networkSecurityGroupTags
)

print "{0} Network Security Group {1} under Resource Group {2}".format(
    get_operation_name(previousDeployed),
    deployed.securityGroupName,
    rg.resourceGroupName)

# asynchronous
op_result = network_client.network_security_groups.create_or_update(
    resource_group_name=rg.resourceGroupName,
    network_security_group_name=deployed.securityGroupName,
    parameters=security_group_params_create,
    raw=True
)

logger.info("Result: {0}".format(op_result))
