create_ci('Environments/Defaults', 'udm.Dictionary',
          {
              'entries': {'usr': 'admin', 'PLACE_HOLDER': 'value'},
              'encryptedEntries': {'secret': 'superSecureValue'}
          })

create_ci('Environments/HistoryDict', 'udm.Dictionary', {'entries': {'one': '1'}})


def update2(ci):
    ci['entries']['two'] = '2'


def update3(ci):
    ci['entries']['three'] = '3'


def update4(ci):
    ci['entries']['four'] = '4'


update_ci('Environments/HistoryDict', update2)
update_ci('Environments/HistoryDict', update3)
update_ci('Environments/HistoryDict', update4)

# Infra and Environment
configurationOvertherSshHost = {
    'address': 'localhost',
    'connectionType': 'SUDO',
    'os': 'UNIX',
    'password': 'root',
    'port': '12345',
    'sudoUsername': 'root',
    'username': 'root'
}
hosts = []
hostDicts = ['Environments/Defaults']
for x in range(1, 21):
    hostId = "Infrastructure/host%d" % x
    if x == 6:
        host6dict = copy.deepcopy(configurationOvertherSshHost)
        host6dict['satellite'] = 'Infrastructure/Satellite/LocalSatelliteGroup'
        create_ci(hostId, 'overthere.SshHost', host6dict)
    else:
        create_ci(hostId, 'overthere.SshHost', configurationOvertherSshHost)
    hosts.append(hostId)
    if x < 3:
        command = "sleep 5" if x % 2 == 1 else "bedtime five"
        create_ci("Environments/hostdict%d" % x, 'udm.Dictionary',
                  {'entries': {'cmd': command},
                   'restrictToContainers': [hostId]})
        hostDicts.append("Environments/hostdict%d" % x)

sameHostId = "Infrastructure/sameHost"
create_ci(sameHostId, 'overthere.SshHost', configurationOvertherSshHost)
create_ci('Environments/EnvsWithSameHost', 'core.Directory')
for x in range(1, 21):
    envId = "Environments/EnvsWithSameHost/EnvWithSameHost%d" % x
    create_ci(envId, 'udm.Environment',
              {'dictionaries': ['Environments/Defaults'], 'members': [sameHostId]})

create_ci('Environments/Env1', 'udm.Environment', {'dictionaries': ['Environments/Defaults']})
create_ci('Environments/EnvWithRequiredChecklist', 'udm.Environment',
            {
                'dictionaries': ['Environments/Defaults'],
                'members': ['Infrastructure/host12'],
                'requiresReleaseNotes': True,
                'requiresPerformanceTested': True,
                'requiresChangeTicketNumber': True,
                'requiresTestValueOne': True,
                'requiresTestValueTwo': True,
                'requiresTestValueThree': True,
                'requiresTestValueFour': True,
                'requiresTestValueFive': True,
                'requiresTestValueSix': True,
                'requiresTestValueSeven': True,
                'requiresTestValueEight': True,
                'requiresTestValueNine': True,
                'requiresTestValueTen': True,
            })
create_ci('Environments/MultiHostEnv', 'udm.Environment',
          {'members': hosts[3:5], 'dictionaries': ['Environments/Defaults']})
create_ci('Environments/Staging', 'udm.Environment',
          {'dictionaries': ['Environments/Defaults'], 'members': ['Infrastructure/host2']})
create_ci('Environments/Sandbox', 'udm.Environment',
          {'dictionaries': ['Environments/Defaults'], 'members': ['Infrastructure/host2']})
create_ci('Environments/StagingNoDefaults', 'udm.Environment',
          {'members': ['Infrastructure/host3']})
create_ci('Environments/TestDirEnv', 'core.Directory', {'dictionaries': ['Environments/Defaults']})
create_ci('Environments/TestDirEnv/Env2', 'udm.Environment', {'dictionaries': ['Environments/Defaults']})
create_ci('Environments/EnvWithDictionaries', 'udm.Environment',
          {'dictionaries': hostDicts, 'members': hosts[9:11]})

create_ci('Infrastructure/HostForUpdateScenario',
          'overthere.SshHost', configurationOvertherSshHost)
create_ci('Environments/EnvForUpdateScenario', 'xl.Environment',
          {'members': ['Infrastructure/HostForUpdateScenario'], 'dictionaries': ['Environments/Defaults']})

create_ci('Infrastructure/ExampleHost', 'overthere.SshHost', configurationOvertherSshHost)
create_ci('Infrastructure/ExampleHost/ExampleServer', 'example.Server', {'home': '/tmp'})

create_ci('Infrastructure/ExampleHostWithTags', 'overthere.SshHost',
          {
              'address': 'localhost',
              'connectionType': 'SUDO',
              'os': 'UNIX',
              'password': 'root',
              'port': '12345',
              'sudoUsername': 'root',
              'username': 'root',
              'tags': ['tag1', 'tag2', 'hostTag', 'deployTag']
          })

members = ['Infrastructure/ExampleHost', 'Infrastructure/ExampleHost/ExampleServer',
           'Infrastructure/ExampleHostWithTags']
for i in range(1, 10):
    hostId = 'Infrastructure/ExampleHostWithTags' + str(i)
    create_ci(hostId, 'overthere.SshHost',
              {
                  'address': 'localhost',
                  'connectionType': 'SUDO',
                  'os': 'UNIX',
                  'password': 'root',
                  'port': '12345',
                  'sudoUsername': 'root',
                  'username': 'root',
                  'tags': ['tag1', 'tag2', 'tag' + str(i)]
              })

    members.append(hostId)

create_ci('Environments/EnvForExampleHostWithTags', 'xl.Environment',
          {'members': members})

create_ci('Environments/EnvForExampleHost', 'xl.Environment',
          {'members': ['Infrastructure/ExampleHost', 'Infrastructure/ExampleHost/ExampleServer']})

tc_host_id = 'Infrastructure/TcHost'
create_ci(tc_host_id, 'overthere.SshHost', configurationOvertherSshHost)
tc_server_id = 'Infrastructure/TcHost/TcServer'
create_ci(tc_server_id, 'tc.Tomcat', {'home': '/etc/'})
create_ci('Environments/TcEnvHost', 'xl.Environment', {'members': [tc_host_id, tc_server_id]})

create_ci('Infrastructure/jboss-host', 'overthere.SshHost',
          {
              'address': 'jboss-7',
              'connectionType': 'SFTP',
              'os': 'UNIX',
              'password': 'centos',
              'username': 'root'
          })

create_ci('Infrastructure/jboss-host/jboss-domain', 'jbossdm.Domain',
          {
              'home': '/opt/jboss/7',
              'host': 'Infrastructure/jboss-host',
              'password': 'jboss',
              'username': 'jbossAdmin'
          })

dictionariesFolder = 'Environments/MultipleDictionaries'
multipleDictionariesFolder = dictionariesFolder + '/Dictionaries'
create_ci(dictionariesFolder, 'core.Directory')
create_ci(multipleDictionariesFolder, 'core.Directory')

dictionaryIds = []
for x in range(1, 16):
    dictId = multipleDictionariesFolder + '/Dict' + str(x)
    dictionaryIds.append(dictId)
    create_ci(dictId, 'udm.Dictionary')

create_ci(dictionariesFolder + '/MultiDictionaryEnvironment', 'xl.Environment', {'dictionaries': dictionaryIds})

def addLookup(ci):
    provider = repository.read('Configuration/Vault/VaultLookupValueProvider')
    ci.lookup["password"] = provider, "HOST_PASSWD"

vaultFolder = 'Infrastructure/Vault'
create_ci(vaultFolder, 'core.Directory')
create_ci(vaultFolder + '/Host', 'overthere.SshHost', {
    'externalProperties': {
        'password': {
            'kind': 'lookup',
            'provider': 'Configuration/Vault/VaultLookupValueProvider',
            'key': 'HOST_PASSWD'
        }
    },
    'address': 'localhost',
    'connectionType': 'SUDO',
    'os': 'UNIX',
    'port': '12345',
    'sudoUsername': 'root',
    'username': 'root',
    'tags': []
})

update_ci(vaultFolder + '/Host', addLookup)
