from cf.client import SpaceClient

class ManifestService(object):

    def __init__(self, container):
        self.space_client = SpaceClient.create_client(container)

    def create_manifest_application(self, file, app_names):
        print("Checking for currently existing applications with names " + str(app_names))
        self.space_client.check_applications_exists(app_names)
        print("No applications currently exist with names " + str(app_names))
        print("Reading manifest file...")
        self.space_client.push_manifest_application(file)

    def modify_manifest_application(self, file):
        print("Reading manifest file...")
        self.space_client.push_manifest_application(file)