package com.xebialabs.deployit.plugin.codepipeline.helpers;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;

import java.util.List;

public abstract class ConfigurationItemUtils {

    public static String getNameFromId(String id) {
        String[] nameParts = id.split("/");
        return nameParts[nameParts.length - 1];
    }

    public static String getParentId(String id) {
        String[] nameParts = id.split("/");
        List<String> list = Lists.newArrayList(nameParts);
        if (list.size() > 1) {
            list.remove(nameParts.length - 1);
        }
        return Joiner.on("/").join(list);
    }

    public static String getId(String deploymentPackageName, String deploymentPackageVersion) {
        return deploymentPackageName + "/" + deploymentPackageVersion;
    }
}
