/**
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS
 * FOR A PARTICULAR PURPOSE. THIS CODE AND INFORMATION ARE NOT SUPPORTED BY XEBIALABS.
 */
package com.xebialabs.deployit.plugin.codepipeline.steps;

import com.amazonaws.services.codepipeline.model.Job;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.codepipeline.processor.JobProcessor;
import com.xebialabs.deployit.plugin.codepipeline.services.CodePipelineJobService;

import java.util.Date;

public class CodePipelineStep implements Step {

    private final String xlDeployServerKey;
    private final JobProcessor jobProcessor;
    private final CodePipelineJobService jobService;

    public CodePipelineStep(String xlDeployServerKey, CodePipelineJobService jobService, JobProcessor jobProcessor) {
        this.xlDeployServerKey = xlDeployServerKey;
        this.jobService = jobService;
        this.jobProcessor = jobProcessor;
    }

    @Override
    public int getOrder() {
        return 1;
    }

    @Override
    public String getDescription() {
        return "Polling CodePipeline for XLD server " + xlDeployServerKey;
    }


    @Override
    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        try {
            ctx.logOutput("Polling Code Pipeline..." + new Date());
            Job job = jobService.getJob(xlDeployServerKey);
            if (job != null) {
                ctx.logOutput(String.format("Found job %s to process", job.getId()));
                return jobProcessor.processJob(job);
            }
            ctx.logOutput("Found no job to process");
            return StepExitCode.SUCCESS;
        } catch (Exception e) {
            ctx.logError(e.getMessage(), e);
            return StepExitCode.FAIL;
        }
    }


}
