/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.codepipeline.steps;

import com.amazonaws.services.codepipeline.model.Job;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.codepipeline.processor.JobProcessor;
import com.xebialabs.deployit.plugin.codepipeline.services.CodePipelineJobService;
import java.util.Date;

public class CodePipelineStep
implements Step {
    private final String xlDeployServerKey;
    private final JobProcessor jobProcessor;
    private final CodePipelineJobService jobService;

    public CodePipelineStep(String xlDeployServerKey, CodePipelineJobService jobService, JobProcessor jobProcessor) {
        this.xlDeployServerKey = xlDeployServerKey;
        this.jobService = jobService;
        this.jobProcessor = jobProcessor;
    }

    public int getOrder() {
        return 1;
    }

    public String getDescription() {
        return "Polling CodePipeline for XLD server " + this.xlDeployServerKey;
    }

    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        try {
            ctx.logOutput("Polling Code Pipeline..." + new Date());
            Job job = this.jobService.getJob(this.xlDeployServerKey);
            if (job != null) {
                ctx.logOutput(String.format("Found job %s to process", job.getId()));
                return this.jobProcessor.processJob(job);
            }
            ctx.logOutput("Found no job to process");
            return StepExitCode.SUCCESS;
        }
        catch (Exception e) {
            ctx.logError(e.getMessage(), (Throwable)e);
            return StepExitCode.FAIL;
        }
    }
}

