import xml.dom.minidom
from dp import common

class HttpResponse:
    def getStatus(self):
        """
        Gets the status code
        :return: the http status code
        """
        return self.status

    def getResponse(self):
        """
        Gets the response content
        :return: the reponse as text
        """
        return self.response

    def getResponseXml(self):
        """
        Gets the response content
        :return: the reponse as XML formatted text
        """
        responseText = xml.dom.minidom.parseString(self.response)

        return responseText.toprettyxml()

    def ensureSuccessStatusCode (self):
        if not self.isSuccessful():
            raise common.DataPowerError("Import unsuccessful", self.status)
        
        if "ERROR" in self.response:
            raise common.DataPowerError("Import error", self.status)

        if "Authentication failure" in self.response:
            raise common.DataPowerError("Authentication failure", self.status)     

    def isSuccessful(self):
        """
        Checks if request successful
        :return: true if successful, false otherwise
        """
        return 200 <= self.status < 400

    def getHeaders(self):
        """
        Returns the response headers
        :return: a dictionary of all response headers
        """
        return self.headers

    def errorDump(self):
        """
        Dumps the whole response
        """
        print 'Status: ', self.status, '\n'
        print 'Response: ', self.response, '\n'
        print 'Response headers: ', self.headers, '\n'

    def __init__(self, status, response, headers):
        self.status = status
        self.response = response
        self.headers = {}
        for header in headers:
            self.headers[str(header.getName())] = str(header.getValue())