/*
 * Decompiled with CFR 0.152.
 */
package org.xebialabs.googlecloud;

import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.util.PemReader;
import com.google.api.client.util.SecurityUtils;
import com.google.api.services.compute.Compute;
import com.google.api.services.compute.model.AccessConfig;
import com.google.api.services.compute.model.Address;
import com.google.api.services.compute.model.AttachedDisk;
import com.google.api.services.compute.model.AttachedDiskInitializeParams;
import com.google.api.services.compute.model.Image;
import com.google.api.services.compute.model.ImageList;
import com.google.api.services.compute.model.Instance;
import com.google.api.services.compute.model.InstanceAggregatedList;
import com.google.api.services.compute.model.InstanceGroup;
import com.google.api.services.compute.model.InstanceGroupList;
import com.google.api.services.compute.model.InstanceGroupManager;
import com.google.api.services.compute.model.InstanceGroupManagersListManagedInstancesResponse;
import com.google.api.services.compute.model.InstanceList;
import com.google.api.services.compute.model.InstanceTemplate;
import com.google.api.services.compute.model.InstancesScopedList;
import com.google.api.services.compute.model.MachineType;
import com.google.api.services.compute.model.MachineTypeAggregatedList;
import com.google.api.services.compute.model.MachineTypesScopedList;
import com.google.api.services.compute.model.ManagedInstance;
import com.google.api.services.compute.model.Metadata;
import com.google.api.services.compute.model.Network;
import com.google.api.services.compute.model.NetworkInterface;
import com.google.api.services.compute.model.Operation;
import com.google.api.services.compute.model.Region;
import com.google.api.services.compute.model.RegionList;
import com.google.api.services.compute.model.ServiceAccount;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.xebialabs.googlecloud.SelfLink;

public class GoogleCloudCompute {
    private static final JsonFactory JSON_FACTORY = JacksonFactory.getDefaultInstance();
    private static final List<String> SCOPES = Arrays.asList("https://www.googleapis.com/auth/cloud-platform");
    private static final String APPLICATION_NAME = "XebiaLabs/1.0";
    private final HttpClient httpClient = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).build();
    private final HttpTransport httpTransport;
    private final GoogleCredential credential;
    private final Compute compute;
    private final String project;

    public GoogleCloudCompute(String client_email, String private_key, String projectId) throws IOException, GeneralSecurityException {
        this.httpTransport = GoogleNetHttpTransport.newTrustedTransport();
        PrivateKey privateKey = GoogleCloudCompute.privateKeyFromPkcs8(private_key);
        GoogleCredential.Builder credentialBuilder = new GoogleCredential.Builder().setTransport(this.httpTransport).setJsonFactory(JSON_FACTORY).setServiceAccountId(client_email).setServiceAccountScopes(Collections.emptyList()).setServiceAccountPrivateKey(privateKey).setServiceAccountProjectId(projectId);
        this.credential = credentialBuilder.build().createScoped(SCOPES);
        this.compute = new Compute.Builder(this.httpTransport, JSON_FACTORY, null).setApplicationName(APPLICATION_NAME).setHttpRequestInitializer((HttpRequestInitializer)this.credential).build();
        this.project = projectId;
    }

    public String sendPost(String url, String location, String token) throws Exception {
        String jsonBinary = this.encodeFileToBase64Binary(location);
        String inputJson = "{\n  \"agentContent\": \"" + jsonBinary + "\"\n}";
        HttpRequest request = HttpRequest.newBuilder().POST(HttpRequest.BodyPublishers.ofString(inputJson)).uri(URI.create(url)).header("Authorization", token).build();
        HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
        System.out.println(response.statusCode());
        return response.body();
    }

    private String encodeFileToBase64Binary(String fileName) throws IOException {
        Path path = Paths.get(fileName, new String[0]);
        byte[] data = Files.readAllBytes(path);
        byte[] encoded = Base64.getEncoder().encode(data);
        return new String(encoded, StandardCharsets.US_ASCII);
    }

    public GoogleCloudCompute(String json_file_path, String projectId) throws IOException, GeneralSecurityException {
        this.credential = GoogleCredential.fromStream((InputStream)new FileInputStream(json_file_path)).createScoped(SCOPES);
        this.httpTransport = GoogleNetHttpTransport.newTrustedTransport();
        this.compute = new Compute.Builder(this.httpTransport, JSON_FACTORY, null).setApplicationName(APPLICATION_NAME).setHttpRequestInitializer((HttpRequestInitializer)this.credential).build();
        this.project = projectId;
    }

    public GoogleCloudCompute(String accessToken, String projectIdf, Boolean rfe) throws IOException, GeneralSecurityException {
        this.httpTransport = GoogleNetHttpTransport.newTrustedTransport();
        GoogleCredential.Builder credentialBuilderNew = new GoogleCredential.Builder().setTransport(this.httpTransport).setJsonFactory(JSON_FACTORY).setClientSecrets("client_id", "client_secret");
        this.credential = credentialBuilderNew.build().createScoped(SCOPES);
        this.credential.setAccessToken(accessToken);
        this.compute = new Compute.Builder(this.httpTransport, JSON_FACTORY, null).setApplicationName(APPLICATION_NAME).setHttpRequestInitializer((HttpRequestInitializer)this.credential).build();
        this.project = projectIdf;
    }

    public String generateToken() throws IOException {
        this.credential.refreshToken();
        return this.credential.getAccessToken();
    }

    public String createInstance(String instanceName, String imageName, String imageProject, String machine, String zone, String externalAddress, Map<String, String> metadata) throws IOException {
        List<MachineType> machineTypesForZone = this.getMachineTypesForZone(machine, zone);
        MachineType machineType = (MachineType)Iterables.getOnlyElement(machineTypesForZone);
        System.out.println("machineType = " + machineType);
        List<Image> images = this.searchImage(imageName, imageProject);
        Image image = (Image)Iterables.getFirst(images, null);
        System.out.println("image = " + image);
        Network network = (Network)this.compute.networks().get(this.project, "default").execute();
        System.out.println("network = " + network);
        Instance instance = new Instance();
        instance.setName(instanceName);
        instance.setMachineType(machineType.getSelfLink());
        NetworkInterface ifc = new NetworkInterface();
        ifc.setNetwork(network.getSelfLink());
        ArrayList<AccessConfig> configs = new ArrayList<AccessConfig>();
        AccessConfig config = new AccessConfig();
        config.setType("ONE_TO_ONE_NAT");
        config.setName("External NAT");
        if (!Strings.isNullOrEmpty((String)externalAddress)) {
            String address = ((Address)this.compute.addresses().get(this.project, this.getRegion(zone), externalAddress).execute()).getAddress();
            System.out.println(externalAddress + "-> Set address = " + address);
            config.setNatIP(address);
        }
        configs.add(config);
        ifc.setAccessConfigs(configs);
        instance.setNetworkInterfaces(Collections.singletonList(ifc));
        AttachedDisk disk = new AttachedDisk();
        disk.setBoot(Boolean.valueOf(true));
        disk.setAutoDelete(Boolean.valueOf(true));
        disk.setType("PERSISTENT");
        AttachedDiskInitializeParams params = new AttachedDiskInitializeParams();
        params.setDiskName(instanceName);
        params.setSourceImage(image.getSelfLink());
        params.setDiskType("https://www.googleapis.com/compute/v1/projects/" + this.project + "/zones/" + zone + "/diskTypes/pd-standard");
        disk.setInitializeParams(params);
        instance.setDisks(Collections.singletonList(disk));
        ServiceAccount account = new ServiceAccount();
        account.setEmail("default");
        ArrayList<String> scopes = new ArrayList<String>();
        scopes.add("https://www.googleapis.com/auth/devstorage.full_control");
        scopes.add("https://www.googleapis.com/auth/compute");
        account.setScopes(scopes);
        instance.setServiceAccounts(Collections.singletonList(account));
        Metadata meta = new Metadata();
        ArrayList items = Lists.newArrayList();
        for (Map.Entry<String, String> entry : metadata.entrySet()) {
            Metadata.Items item = new Metadata.Items();
            item.setKey(entry.getKey());
            item.setValue(entry.getValue());
            items.add(item);
        }
        meta.setItems((List)items);
        instance.setMetadata(meta);
        System.out.println(instance.toPrettyString());
        Compute.Instances.Insert insert = this.compute.instances().insert(this.project, zone, instance);
        Operation execute = (Operation)insert.execute();
        return execute.getName();
    }

    public String createInstancesFromTemplate(String groupName, String templateName, String zone, int targetSize) throws IOException {
        Compute.InstanceTemplates.Get request = this.compute.instanceTemplates().get(this.project, templateName);
        InstanceTemplate response = (InstanceTemplate)request.execute();
        InstanceGroupManager instanceGroupManager = new InstanceGroupManager().setName(groupName).setInstanceTemplate(response.getSelfLink()).setTargetSize(Integer.valueOf(targetSize));
        Operation operation = (Operation)this.compute.instanceGroupManagers().insert(this.project, zone, instanceGroupManager).execute();
        return operation.getName();
    }

    private String getRegion(String zone) throws IOException {
        RegionList response;
        Compute.Regions.List request = this.compute.regions().list(this.project);
        do {
            if ((response = (RegionList)request.execute()).getItems() == null) continue;
            for (Region region : response.getItems()) {
                if (!zone.startsWith(region.getName())) continue;
                return region.getName();
            }
            request.setPageToken(response.getNextPageToken());
        } while (response.getNextPageToken() != null);
        throw new RuntimeException("No region found for zone" + zone);
    }

    private List<Image> searchImage(String imageName, String imageProject) throws IOException {
        ImageList response;
        ArrayList result = Lists.newArrayList();
        String filter = String.format("name eq %s.*", imageName);
        Compute.Images.List request = this.compute.images().list(imageProject).setFilter(filter);
        do {
            if ((response = (ImageList)request.execute()).getItems() == null) continue;
            for (Image image : response.getItems()) {
                result.add(image);
            }
            request.setPageToken(response.getNextPageToken());
        } while (response.getNextPageToken() != null);
        return result;
    }

    protected List<MachineType> getMachineTypesForZone(String machine, String zone) throws IOException {
        MachineTypeAggregatedList response;
        String filter = String.format("(zone eq %s)(name eq %s)", zone, machine);
        System.out.println("Search machine" + machine + " using" + filter);
        Compute.MachineTypes.AggregatedList request = this.compute.machineTypes().aggregatedList(this.project).setFilter(filter);
        ArrayList result = Lists.newArrayList();
        do {
            if ((response = (MachineTypeAggregatedList)request.execute()).getItems() == null) continue;
            for (Map.Entry item : response.getItems().entrySet()) {
                List machineTypes = ((MachineTypesScopedList)item.getValue()).getMachineTypes();
                if (machineTypes == null) continue;
                for (MachineType machineType : machineTypes) {
                    result.add(machineType);
                }
            }
            request.setPageToken(response.getNextPageToken());
        } while (response.getNextPageToken() != null);
        return result;
    }

    public void waitForOperation(String selfLink, String zone) throws Exception {
        System.out.println("Waiting for operation completion...");
        Operation.Error error = this.blockUntilComplete(selfLink, zone, 120000L);
        if (error == null) {
            System.out.println("Success!");
        } else {
            System.out.println(error.toPrettyString());
        }
    }

    public Instance getInstanceByName(String instanceName, String zone) throws IOException {
        Compute.Instances.List instances = this.compute.instances().list(this.project, zone);
        InstanceList list = (InstanceList)instances.execute();
        if (list.getItems() == null) {
            throw new RuntimeException("Instance " + instanceName + " not found in " + zone + " zone");
        }
        for (Instance instance : list.getItems()) {
            if (!instance.getName().equals(instanceName)) continue;
            return instance;
        }
        throw new RuntimeException("Instance " + instanceName + " not found in " + zone + " zone");
    }

    public InstanceGroup getInstanceByGroupName(String groupName, String zone) throws IOException {
        Compute.InstanceGroups.List instances = this.compute.instanceGroups().list(this.project, zone);
        InstanceGroupList list = (InstanceGroupList)instances.execute();
        if (list.getItems() == null) {
            throw new RuntimeException("Group " + groupName + " not found in " + zone + " zone");
        }
        for (InstanceGroup instance : list.getItems()) {
            if (!instance.getName().equals(groupName)) continue;
            return instance;
        }
        throw new RuntimeException("Group " + groupName + " not found in " + zone + " zone");
    }

    public List<String> getManagedInstancesSelfLinkByGroupName(String zone, String resourceId) throws IOException {
        Compute.InstanceGroupManagers.ListManagedInstances instances = this.compute.instanceGroupManagers().listManagedInstances(this.project, zone, resourceId);
        InstanceGroupManagersListManagedInstancesResponse list = (InstanceGroupManagersListManagedInstancesResponse)instances.execute();
        ArrayList managedInstanceSelfLink = Lists.newArrayList();
        if (list.getManagedInstances() == null) {
            throw new RuntimeException("No Instance running in Group " + resourceId + " in " + zone + " zone");
        }
        for (ManagedInstance instance : list.getManagedInstances()) {
            managedInstanceSelfLink.add(instance.getInstance());
        }
        return managedInstanceSelfLink;
    }

    public String deleteInstance(String instanceName, String zone) throws IOException {
        Compute.Instances.Delete delete = this.compute.instances().delete(this.project, zone, instanceName);
        return ((Operation)delete.execute()).getName();
    }

    public Operation.Error blockUntilComplete(String opId, String zone, long timeout) throws Exception {
        long start = System.currentTimeMillis();
        Compute.ZoneOperations.Get init = this.compute.zoneOperations().get(this.project, zone, opId);
        Operation operation = this.getOperation(opId, zone);
        long POLL_INTERVAL = 5000L;
        String status = operation.getStatus();
        String opId2 = operation.getName();
        while (operation != null && !status.equals("DONE")) {
            Compute.GlobalOperations.Get get;
            Thread.sleep(5000L);
            long elapsed = System.currentTimeMillis() - start;
            if (elapsed >= timeout) {
                throw new InterruptedException("Timed out waiting for operation to complete");
            }
            System.out.println("waiting...");
            if (zone != null) {
                get = this.compute.zoneOperations().get(this.project, zone, opId);
                operation = (Operation)get.execute();
            } else {
                get = this.compute.globalOperations().get(this.project, opId);
                operation = (Operation)get.execute();
            }
            if (operation == null) continue;
            status = operation.getStatus();
        }
        return operation == null ? null : operation.getError();
    }

    public Operation getOperation(String opId, String zone) throws IOException {
        Compute.ZoneOperations.Get init = this.compute.zoneOperations().get(this.project, zone, opId);
        return (Operation)init.execute();
    }

    public boolean isOperationDone(String opId, String zone) throws IOException {
        return this.getOperation(opId, zone).getStatus().equals("DONE");
    }

    private static PrivateKey privateKeyFromPkcs8(String privateKeyPem) throws IOException {
        StringReader reader = new StringReader(privateKeyPem);
        PemReader.Section section = PemReader.readFirstSectionAndClose((Reader)reader, (String)"PRIVATE KEY");
        if (section == null) {
            throw new IOException("Invalid PKCS8 data.");
        }
        byte[] bytes = section.getBase64DecodedBytes();
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(bytes);
        GeneralSecurityException unexpectedException = null;
        try {
            KeyFactory keyFactory = SecurityUtils.getRsaKeyFactory();
            PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
            return privateKey;
        }
        catch (NoSuchAlgorithmException exception) {
            unexpectedException = exception;
        }
        catch (InvalidKeySpecException exception) {
            unexpectedException = exception;
        }
        throw new RuntimeException("Unexpected exception reading PKCS data", unexpectedException);
    }

    public List<String> getInstanceNames() throws IOException {
        Compute.Instances.AggregatedList request = this.compute.instances().aggregatedList(this.project);
        InstanceAggregatedList response = (InstanceAggregatedList)request.execute();
        if (response.getItems() == null) {
            return Collections.emptyList();
        }
        ArrayList instanceNames = Lists.newArrayList();
        for (Map.Entry stringInstancesScopedListEntry : response.getItems().entrySet()) {
            List instances = ((InstancesScopedList)stringInstancesScopedListEntry.getValue()).getInstances();
            if (instances == null) continue;
            for (Instance instance : instances) {
                instanceNames.add(instance.getName());
            }
        }
        return instanceNames;
    }

    public Instance getInstanceBySelfLink(String selfLink) throws URISyntaxException, IOException {
        SelfLink sl = new SelfLink(selfLink);
        return this.getInstanceByName(sl.getName(), sl.getZone());
    }

    public String deleteInstanceFromGroup(String groupName, String zone) throws IOException {
        return ((Operation)this.compute.instanceGroupManagers().delete(this.project, zone, groupName).execute()).getName();
    }
}

