#
# Copyright (c) 2021. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai, Inc. and its affiliates, subsidiaries, and licensors.
#

if deployed.type in ["helm.K8SRelease", "helm.OpenshiftRelease"]:
    container = deployed.container.container
elif deployed.type == "helm.K8SReleaseWithNamespace":
    container = deployed.container

if not container.helmClient:
    raise  Exception("Please Check if Helm Client is added in kubernetes/openshift CI.")

context.addStepWithCheckpoint(steps.helm(
    description="Install the Helm {0} release on {1} namespace".format(deployed.name, container.name),
    order=60,
    script="helm/install.py",
    jython_context={"deployed": deployed,'helmclient': container.helmClient,'cluster': container, 'satellite': container.helmClient.host.satellite},
    preview_script="helm/preview_install.py"
), delta)
