#
# Copyright (c) 2021. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai, Inc. and its affiliates, subsidiaries, and licensors.
#
import yaml
from helm.helmrunner import HelmConvertToTemplate
from helm.yaml.dumper import yaml_safe_dump

from java.io import ByteArrayInputStream
from java.lang import String
from java.lang import RuntimeException

if deployed.type == "helm.K8SRelease":
    container = deployed.container.container
    namespace = deployed.container.name
elif deployed.type == "helm.K8SReleaseWithNamespace":
    container = deployed.container
    namespace = deployed.namespace

context.addStepWithCheckpoint(steps.jython(
    description="Upgrade the Helm {0} release on {1} namespace".format(deployed.name, namespace),
    order=60,
    script="helm/upgrade.py",
    jython_context={"deployed": deployed,'helmclient': container.helmClient,'cluster': container},
    preview_script="helm/preview_upgrade.py"
), delta)

if "stitch" in dir():
    response = HelmConvertToTemplate(container.helmClient, container).execute(deployed)
    chartYaml = response["response"]

    data_to_validate = list(yaml.load_all(chartYaml))
    context_to_validate = {"format": "yaml", "invocationName": deployed.name}

    for yaml_content in data_to_validate:
        try:
            context.getArtifactTransformer("stitchEngine").validate(ByteArrayInputStream(String(yaml_safe_dump(yaml_content)).getBytes()), context_to_validate)
        except RuntimeException as e:
            raise Exception("-------- Stitch Validation exception ---------- {}".format(e.getMessage()))
