#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

import yaml
import re

def yaml_safe_load_all(data):

    return yaml.safe_load_all(data.replace("{{", "({(").replace("}}", ")})"))

def yaml_sanitize_load_all(data):
    replaced_data = re.sub(r'^(\s*)-\s*=\s*$', r'\1- "=~"', data, flags=re.MULTILINE)
    return yaml.load_all(replaced_data, Loader=yaml.FullLoader)