from xld.kubernetes.factories.handler_factory import ContainerHelperFactory
from xld.kubernetes.statefulset.statefulset_helper import StatefulSetHelper


class StatefulSetStepsGenerator(object):
    def __init__(self, context, steps):
        self.__context = context
        self.__steps = steps
        self.__statefulset_helper = StatefulSetHelper()

    def replace(self, delta, deployed, previousDeployed):
        container_helper = ContainerHelperFactory(deployed.container).create()

        self.__context.addStepWithCheckpoint(self.__steps.jython(
            description="Restart StatefulSet {0} on {1}".format(self.__statefulset_helper.get_statefulset_name(deployed),
                                                                container_helper.get_container_name(deployed.container)),
            script="xld/kubernetes/statefulset/restart_statefulset.py",
            jython_context={"deployed": deployed, "previousDeployed": previousDeployed},
            order=deployed.modifyOrder
        ), delta)

        if deployed.minimumPodCount > 0:
            self.__context.addStepWithCheckpoint(self.__steps.jython(
                description="Wait for StatefulSet {0} to be in running state".format(
                    self.__statefulset_helper.get_statefulset_name(deployed)),
                script="xld/kubernetes/statefulset/wait_for_statefulset_ready.py",
                jython_context={"deployed": deployed, "previousDeployed": previousDeployed},
                order=deployed.modifyOrder
            ), delta)
