#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

from xld.kubernetes.factories.handler_factory import ContainerHelperFactory
from xld.kubernetes.persistent_volume_claim.helper import PVCHelper
from xld.kubernetes.persistent_volume_claim.service import PersistentVolumeClaimService

container_helper = ContainerHelperFactory(deployed.container).create()
pvc_service = PersistentVolumeClaimService(deployed)
pvc_name = PVCHelper.get_name(deployed)

counter_name = "retry_{0}_{1}".format(pvc_name, container_helper.get_container_name(deployed.container))
retry_counter = context.getAttribute(counter_name) if context.getAttribute(counter_name) else 1

if retry_counter <= deployed.createRetryCount:
    if not pvc_service.is_existing():
        raise RuntimeError('Error creating PersistentVolumeClaim on %s' % container_helper.get_container_name(deployed.container))

    if not pvc_service.is_bound(pvc_name):
        print("Waiting for PersistentVolumeClaim {0} to be in bound phase".format(pvc_name))
        context.setAttribute(counter_name, retry_counter + 1)
        result = "RETRY"
    else:
        print("PersistentVolumeClaim created successfully.")
else:
    context.setAttribute(counter_name, 0)
    raise RuntimeError('Step retry timed out.')
