/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.kubernetes.inspect;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.inspection.InspectionContext;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.kubernetes.OrderedBaseDeployed;
import com.xebialabs.deployit.plugin.kubernetes.inspect.InspectableContainer;
import com.xebialabs.deployit.plugin.kubernetes.inspect.JythonInspectionStep;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import javax.script.ScriptEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatedInspectionHelper {
    public static final String DISCOVER_SCRIPT_PROPERTY_NAME = "inspectionScript";
    private static Logger logger = LoggerFactory.getLogger(DelegatedInspectionHelper.class);

    public static void discoverDeployeds(InspectableContainer container, InspectionContext ctx, Iterable<Type> types, ScriptEngine engine) {
        Multimap<Integer, JythonInspectionStep> steps = DelegatedInspectionHelper.newSortedKeyMultimapForSteps();
        Type containerT = container.getType();
        for (Type deployedT : types) {
            Descriptor deployedD = deployedT.getDescriptor();
            logger.debug("Checking whether type [{}] is not virtual", (Object)deployedT);
            if (deployedD.isVirtual()) continue;
            Type deployedContainerT = deployedD.getContainerType();
            Type k8sContainerT = Type.valueOf(InspectableContainer.class);
            logger.debug("Checking whether type [{}] is instance of type [{}]", (Object)deployedContainerT, (Object)k8sContainerT);
            if (!containerT.instanceOf(k8sContainerT)) continue;
            logger.debug("Checking whether type [{}] has a discoveryScript property", (Object)deployedT);
            PropertyDescriptor discoveryScriptProperty = deployedD.getPropertyDescriptor(DISCOVER_SCRIPT_PROPERTY_NAME);
            if (discoveryScriptProperty == null) continue;
            logger.debug("Checking whether the inspectionScript property of type [{}] has a default value", (Object)deployedT);
            Object defaultValue = discoveryScriptProperty.getDefaultValue();
            if (defaultValue == null) continue;
            logger.debug("Checking whether the inspectionScript property of type [{}] has a string value", (Object)deployedD.getType());
            if (!(defaultValue instanceof String)) continue;
            String scriptName = (String)defaultValue;
            logger.debug("Adding inspection step using script {} for container {}", (Object)scriptName, (Object)container);
            HashMap pythonVars = Maps.newHashMap();
            pythonVars.put("container", container);
            OrderedBaseDeployed prototype = (OrderedBaseDeployed)deployedD.newInstance(null);
            prototype.setId(String.valueOf(System.identityHashCode((Object)prototype)));
            pythonVars.put("prototype", prototype);
            JythonInspectionStep step = new JythonInspectionStep(scriptName, pythonVars, "Discover objects of type " + deployedT + " on " + container, engine);
            steps.put((Object)prototype.getDiscoverOrder(), (Object)step);
        }
        for (JythonInspectionStep step : steps.values()) {
            ctx.addStep((Step)step);
        }
    }

    private static Multimap<Integer, JythonInspectionStep> newSortedKeyMultimapForSteps() {
        return Multimaps.newListMultimap(new TreeMap(), (Supplier)new Supplier<List<JythonInspectionStep>>(){

            public List<JythonInspectionStep> get() {
                return Lists.newArrayList();
            }
        });
    }
}

