from xld.kubernetes.core_api_client import KubernetesCoreClient
from xld.kubernetes.apps_api_client import KubernetesAppsClient

k8s_master = container.getProperty("k8sMaster")
api_client = KubernetesAppsClient(k8s_master)

inspected = inspectionContext.getInspected()
deployment_ci_list = []

for key in inspected:
    ci = inspected[key]
    if str(ci.type) == 'k8s.Namespace':
        namespaceName = ci.getProperty("namespaceName")
        if ci.getProperty("token"):
            api_client = KubernetesAppsClient(k8s_master, ci.getProperty("token"))

        deployments = api_client.get_apps_api().list_namespaced_deployment(namespace=namespaceName, pretty='true', watch=False)

        deployment_list = deployments.items
        for deployment in deployment_list:
            metadata = deployment.metadata
            deployment_name = metadata.name
            deployment_id = "%s/%s" % (ci.id, deployment_name)
            deployment_ci = Type.valueOf("k8s.Deployment").descriptor.newInstance(deployment_id)

            deployment_ci.setProperty("deploymentName", deployment_name)
            deployment_ci.setProperty("minimumReadySeconds", deployment.spec.min_ready_seconds)
            deployment_ci.setProperty("paused", deployment.spec.paused)
            deployment_ci.setProperty("progressDeadlineSeconds", deployment.spec.progress_deadline_seconds)
            deployment_ci.setProperty("replicasCount", deployment.spec.replicas)
            deployment_ci.setProperty("revisionHistoryLimit", deployment.spec.revision_history_limit)

            deployment_ci_list.append(deployment_ci)
            print("Discovered Deployment %s in namespace %s" % (deployment_name, namespaceName))


for ci in deployment_ci_list:
    inspectionContext.discovered(ci)
    inspectionContext.inspected(ci)
