from xld.kubernetes.core_api_client import KubernetesCoreClient

k8s_master = container.getProperty("k8sMaster")
api_client = KubernetesCoreClient(k8s_master)
inspected = inspectionContext.getInspected()
discovered_pods = []

for key in inspected:
    ci = inspected[key]
    if str(ci.type) == 'k8s.Namespace':
        namespaceName = ci.getProperty("namespaceName")
        if ci.getProperty("token"):
            api_client = KubernetesCoreClient(k8s_master, ci.getProperty("token"))
        pods = api_client.core_api.list_namespaced_pod(namespace=namespaceName, pretty='true', watch=False)

        pod_list = pods.items
        pod_ci_list = []
        for pod_obj in pod_list:
            metadata = pod_obj.metadata
            podname = metadata.name
            labels = metadata.labels
            hostnetwork = pod_obj.spec.host_network
            restart_policy = pod_obj.spec.restart_policy
            pod_id = "%s/%s" % (ci.id, podname)
            pod_ci = Type.valueOf("k8s.Pod").descriptor.newInstance(pod_id)
            pod_ci.setProperty("labels", labels)
            if hostnetwork:
                pod_ci.setProperty("hostNetwork", "true")
            pod_ci.setProperty("restartPolicy", restart_policy)
            discovered_pods.append(pod_ci)
            print("Discovered Pod %s in namespace %s" % (podname, namespaceName))


for ci in discovered_pods:
    inspectionContext.discovered(ci)
    inspectionContext.inspected(ci)
