from xld.kubernetes.core_api_client import KubernetesCoreClient

k8s_master = container.getProperty("k8sMaster")
api_client = KubernetesCoreClient(k8s_master)
inspected = inspectionContext.getInspected()
discovered_secrets = []

for key in inspected:
    ci = inspected[key]
    if str(ci.type) == 'k8s.Namespace':

        namespaceName = ci.getProperty("namespaceName")
        if ci.getProperty("token"):
            api_client = KubernetesCoreClient(k8s_master, ci.getProperty("token"))
        secret_list = api_client.core_api.list_namespaced_secret(namespace=namespaceName)
        secrets = secret_list.items

        for secret in secrets:
            secret_name = secret.metadata.name
            secret_id = "%s/%s" % (ci.id, secret_name)
            secret_ci = Type.valueOf("k8s.Secret").descriptor.newInstance(secret_id)
            secret_ci.setProperty("secretName", secret_name)
            secret_ci.setProperty("secretType", secret.type)
            secret_ci.setProperty("data", secret.data)
            discovered_secrets.append(secret_ci)
            print("Discovered secret %s in namespace %s" % (secret_name, namespaceName))

for ci in discovered_secrets:
    inspectionContext.discovered(ci)
    inspectionContext.inspected(ci)
