import importlib

class ContainerHelperFactory:
    def __init__(self, container):
        self.__container = container

    def create(self):
        return self.__resolve_helper()

    def __resolve_helper(self):
        words = self.__container.containerHelper.split('.')
        clazz = words[len(words)-1]
        module = self.__container.containerHelper.replace(".{0}".format(clazz), "")
        factory_module = importlib.import_module(module)
        client_clazz = getattr(factory_module, clazz)
        instance = client_clazz()
        return instance

class ApiClientFactory:
    def __init__(self, container):
        self.__container = container

    def create(self):
        client = self.__resolve_client()
        return client.create()

    def __resolve_client(self):
        words = self.__container.clientFactory.split('.')
        clazz = words[len(words)-1]
        module = self.__container.clientFactory.replace(".{0}".format(clazz), "")
        factory_module = importlib.import_module(module)
        client_clazz = getattr(factory_module, clazz)
        instance = client_clazz(self.__container)
        return instance
