from xld.kubernetes.factories.handler_factory import ContainerHelperFactory
from xld.kubernetes.pod.pod_helper import PodHelper

container_helper = ContainerHelperFactory(deployed.container).create()

context.addStepWithCheckpoint(steps.jython(
    description="Create pod {0} in {1} {2}".format(PodHelper.get_pod_name(deployed),
                                                   container_helper.get_container_label(),
                                                   container_helper.get_container_name(deployed.container)),
    script="xld/kubernetes/pod/create_pod.py",
    order=61
), delta)

context.addStepWithCheckpoint(steps.jython(
    description="Wait for pod {0} to be in running state".format(PodHelper.get_pod_name(deployed)),
    script="xld/kubernetes/pod/wait_for_pod_creation.py",
    order=62
), delta)
