from xld.kubernetes.factories.handler_factory import ContainerHelperFactory

from xld.kubernetes.factories.handler_factory import ResourceFactoryResolver
from xld.kubernetes.resource.helper import ResourceHelper


class ResourceService:
    def __init__(self, deployed):
        self.__deployed = deployed
        self.__container_helper = ContainerHelperFactory(deployed.container).create()
        self.__resource_factory = ResourceFactoryResolver(deployed).get_factory()
        self.__data = ResourceHelper(deployed).parse()

    def create(self):
        return [self.__create_resource(item) for item in self.__data['items']] \
            if self.__data['kind'] == 'List' else self.__create_resource(self.__data)

    def update(self):
        return [self.__update_resource(item) for item in self.__data['items']] \
            if self.__data['kind'] == 'List' else self.__update_resource(self.__data)

    def delete(self):
        return [self.__delete_resource(item) for item in self.__data['items']] \
            if self.__data['kind'] == 'List' else self.__delete_resource(self.__data)

    def __create_resource(self, item):
        print "Creating resource {0} on {1} {2}".format(item['kind'], self.__container_helper.get_container_name(self.__deployed.container),
                                                        self.__deployed.container)
        resource = self.__resource_factory.get(item)
        resource.create(namespace=self.__container_helper.get_container_name(self.__deployed.container),
                        resource_definition=item)

    def __update_resource(self, item):
        print "Updating resource {0} on {1}".format(item['kind'], self.__container_helper.get_container_name(self.__deployed.container),
                                                    self.__deployed.container)
        resource = self.__resource_factory.get(item)
        resource.modify(namespace=self.__container_helper.get_container_name(self.__deployed.container),
                        resource_definition=item)

    def __delete_resource(self, item):
        print "Deleting resource {0} on {1}".format(item['kind'], self.__container_helper.get_container_name(self.__deployed.container),
                                                    self.__deployed.container)
        resource = self.__resource_factory.get(item)
        resource.delete(namespace=self.__container_helper.get_container_name(self.__deployed.container),
                        resource_definition=item)
