from xld.kubernetes.secret.secret_helper import SecretHelper
from xld.kubernetes.core_api_client import KubernetesCoreClient
from xld.kubernetes.factories.handler_factory import ContainerHelperFactory
from kubernetes import client as kubernetes_client
from kubernetes.client.rest import ApiException


class SecretService(object):
    def __init__(self):
        self.__secret_helper = SecretHelper()

    def create_secret(self, deployed):
        secret_request = self.__secret_helper.read_secret(deployed_secret=deployed)
        container_helper = self.__create_container_helper(deployed.container)
        client = self.__create_client(deployed.container.container)
        print("Creating secret '{0}' in {1} '{2}' ".format(self.__secret_helper.get_secret_name(deployed),
                                                           container_helper.get_container_label(),
                                                           container_helper.get_container_name(
                                                                deployed.container)))
        secret_response = client.get_core_api().create_namespaced_secret(
            namespace=container_helper.get_container_name(deployed.container),
            body=secret_request)
        return secret_response

    def update_secret(self, deployed):
        secret_request = self.__secret_helper.read_secret(deployed_secret=deployed)
        container_helper = self.__create_container_helper(deployed.container)
        client = self.__create_client(deployed.container.container)
        print("Updating secret '{0}' in {1} '{2}' ".format(self.__secret_helper.get_secret_name(deployed),
                                                           container_helper.get_container_label(),
                                                           container_helper.get_container_name(deployed.container)))
        secret_response = client.get_core_api().replace_namespaced_secret(
            name=self.__secret_helper.get_secret_name(deployed),
            namespace=container_helper.get_container_name(deployed.container),
            body=secret_request)
        return secret_response

    def destroy_secret(self, previous_deployed):
        container_helper = self.__create_container_helper(previous_deployed.container)
        client = self.__create_client(previous_deployed.container.container)
        print("Destroying secret '{0}' from {1} '{2}' ".format(
            self.__secret_helper.get_secret_name(previous_deployed),
            container_helper.get_container_label(),
            container_helper.get_container_name(previous_deployed.container)))
        client.get_core_api().delete_namespaced_secret(name=self.__secret_helper.get_secret_name(previous_deployed),
                                                       namespace=container_helper.get_container_name
                                                       (previous_deployed.container),
                                                       body=kubernetes_client.V1DeleteOptions())

    def is_secret_existing(self, deployed):
        try:
            client = self.__create_client(deployed.container.container)
            secret = client.get_core_api().read_namespaced_secret(name=self.__secret_helper.get_secret_name(deployed),
                                                                  namespace=self.__create_container_helper
                                                                  (deployed.container).get_container_name
                                                                  (deployed.container))
            if secret:
                return True
        except ApiException as e:
            if e.status == 404:
                return False

    @staticmethod
    def __create_client(container):
        return KubernetesCoreClient(container)

    @staticmethod
    def __create_container_helper(container):
        return ContainerHelperFactory(container).create()
