from xld.kubernetes.factories.handler_factory import ContainerHelperFactory
from xld.kubernetes.persistent_volume.service import PersistentVolumeService
from xld.kubernetes.persistent_volume_claim.helper import PVCHelper

container_helper = ContainerHelperFactory(deployed.container).create()
pvc_helper = PVCHelper(deployed)

pvc_helper.should_not_modify_name(previousDeployed)
pvc_helper.should_not_modify_volume(previousDeployed)
pvc_helper.should_check_retain_policy()

context.addStepWithCheckpoint(steps.jython(
    description="Destroy PersistentVolumeClaim {0} from {1}".format(PVCHelper.get_name(previousDeployed),
                                                                    container_helper.get_container_name(
                                                                          previousDeployed.container)),
    script="xld/kubernetes/persistent_volume_claim/steps/destroy.py",
    order=51
), delta)

context.addStep(steps.jython(
    description="Wait for PersistentVolumeClaim {0} to be destroyed completely".format(
        PVCHelper.get_name(previousDeployed)),
    script="xld/kubernetes/persistent_volume_claim/steps/wait_for_deletion.py",
    order=52
))

context.addStepWithCheckpoint(steps.jython(
    description="Create PersistentVolumeClaim {} on {}".format(
        PVCHelper.get_name(deployed),
        container_helper.get_container_name(deployed.container)),
    script="xld/kubernetes/persistent_volume_claim/steps/create.py",
    order=59
), delta)

context.addStep(steps.jython(
    description="Wait for PersistentVolumeClaim to be in bound phase",
    script="xld/kubernetes/persistent_volume_claim/steps/wait_for_creation.py",
    order=60
))
