from xld.kubernetes.deployment.deployment_helper import DeploymentHelper
from xld.kubernetes.factories.handler_factory import ContainerHelperFactory
from xld.kubernetes.pod.pod_helper import PodHelper

container_helper = ContainerHelperFactory(deployed.container).create()
PodHelper.validate_pod(deployed_pod=deployed)
deployment_helper = DeploymentHelper()

if deployed.minimumPodCount > deployed.replicasCount:
    raise RuntimeError("Minimum pod count should not be more than replicas count.")

if previousDeployed and (deployment_helper.get_deployment_name(previousDeployed) != deployment_helper.get_deployment_name(deployed)):
    raise RuntimeError('Deployment name should not be modified.')

if not deployed.matchExpressions and not deployed.matchLabels:
    raise RuntimeError("Match Expressions or Match Labels should not be empty.")

if not deployed.labels:
    raise RuntimeError("Labels should not be empty.")

context.addStepWithCheckpoint(steps.jython(
    description="{0} Deployment {1} on {2}".format(
        'Modify' if previousDeployed else 'Create', DeploymentHelper().get_deployment_name(deployed),
        container_helper.get_container_name(deployed.container)),
    script="xld/kubernetes/deployment/%s" % ('modify_deployment.py' if previousDeployed else 'create_deployment.py'),
    order=61
), delta)

if deployed.minimumPodCount > 0:
    context.addStepWithCheckpoint(steps.jython(
        description="Wait for Deployment {0} to be in running state".format(deployment_helper.get_deployment_name(deployed)),
        script="xld/kubernetes/deployment/wait_for_deployment_ready.py",
        order=62
    ), delta)
