import importlib


def resolve_class(class_path):
    words = class_path.split('.')
    clazz = words[len(words) - 1]
    module = class_path.replace(".{0}".format(clazz), "")
    factory_module = importlib.import_module(module)
    client_clazz = getattr(factory_module, clazz)
    return client_clazz

class ContainerHelperFactory:
    def __init__(self, container):
        self.__container = container

    def create(self):
        return self.__resolve_helper()

    def __resolve_helper(self):
        client_clazz = resolve_class(self.__container.containerHelper)
        instance = client_clazz()
        return instance


class ApiClientFactory:
    def __init__(self, container):
        self.__container = container

    def create(self):
        client = self.__resolve_client()
        return client.create()

    def __resolve_client(self):
        client_clazz = resolve_class(self.__container.clientFactory)
        instance = client_clazz(self.__container)
        return instance

class ResourceFactoryResolver(object):
    def __init__(self, deployed):
        self.__deployed = deployed

    def get_factory(self):
        return self.__resolve()

    def __resolve(self):
        client_clazz = resolve_class(self.__deployed.resourceFactory)
        instance = client_clazz(self.__deployed)
        return instance
