from kubernetes import client
from kubernetes.client.api_client import ApiClient


class SecretHelper(object):

    def read_secret(self, deployed_secret):
        secret = client.V1Secret()
        secret.metadata = client.V1ObjectMeta(name=self.get_secret_name(deployed_secret))
        secret.type = deployed_secret.secretType
        secret.string_data = deployed_secret.data.copy()
        secret.string_data.update(self.get_secret_files(deployed_secret.propertyFiles))
        secret = ApiClient().sanitize_for_serialization(secret)
        return secret

    @staticmethod
    def get_secret_name(deployed_secret):
        return deployed_secret.secretName if deployed_secret.secretName else deployed_secret.name

    @staticmethod
    def get_secret_files(deployed_files):
        return dict((deployed_file.file.name, open(deployed_file.file.path).read()) for deployed_file in deployed_files)
