#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

from xld.kubernetes.deployment.deployment_helper import DeploymentHelper
from xld.kubernetes.factories.handler_factory import ContainerHelperFactory

container_helper = ContainerHelperFactory(previousDeployed.container).create()
deployment_name = DeploymentHelper().get_deployment_name(previousDeployed)


context.addStepWithCheckpoint(steps.jython(
    description="Destroy Deployment {0} from {1}".format(deployment_name, container_helper.get_container_name(previousDeployed.container)),
    script="xld/kubernetes/deployment/remove_deployment.py",
    order=39
), delta)

# Wait for deployment delete
context.addStepWithCheckpoint(steps.jython(
    description="Wait for Deployment {0} to be destroyed completely".format(deployment_name),
    script="xld/kubernetes/deployment/wait_for_deployment_deletion.py",
    order=40
), delta)
