#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

from kubernetes import client
from kubernetes.client.rest import ApiException
from xld.kubernetes import KubernetesBaseClient


class KubernetesExtensionsClient(KubernetesBaseClient):

    def __init__(self, container):
        super(KubernetesExtensionsClient, self).__init__(container)

    def get_extensions_api(self):
        print ("[Using API version: {}]".format(self.get_api_version()))
        return client.ExtensionsV1beta1Api(self.internal_api_client)

    def get_api_version(self):
        return "extensions/v1beta1"

    def read_ingress(self, name, namespace):
        return self.get_extensions_api().read_namespaced_ingress(name=name, namespace=namespace)

    def create_ingress(self, ingress_body, namespace):
        return self.get_extensions_api().create_namespaced_ingress(namespace=namespace, body=ingress_body)

    def delete_ingress(self, name, namespace):
        body = client.V1DeleteOptions(orphan_dependents=False, grace_period_seconds=0)
        return self.get_extensions_api().delete_namespaced_ingress(name=name, body=body, namespace=namespace)

    def replace_ingress(self, name, ingress_body, namespace):
        return self.get_extensions_api().replace_namespaced_ingress(name=name, namespace=namespace, body=ingress_body)

    def is_ingress_existing(self, name, namespace):
        try:
            ingress = self.read_ingress(name=name, namespace=namespace)
            if ingress:
                return True
        except ApiException as e:
            if e.status == 404:
                return False
